/*  ZSocket.h
	ZSocket Component
	Copyright 1997 ZBuilder Software
    All Rights Reserved

    Version 1.0.0 	Production release

*/

#ifndef socketH
#define socketH

#include <windows.h>
#include <winsock.h>

#define WM_ASYNCSELECT	WM_USER+0
#define WM_NAME_DNS		WM_USER+1
#define TIMER_TIMEOUT	10

// states (FState)

#define ZS_CLOSED		1
#define ZS_OPEN			2
#define ZS_LISTEN		3
#define ZS_CONNPEND		4
#define ZS_LOOKUPHOST	5
#define ZS_HOSTFOUND	6
#define ZS_CONNECTING	7
#define ZS_CONNECTED	8
#define ZS_ERROR	 	9
#define ZS_CANCEL		10
#define ZS_ACCEPTING	11


// Errors

#define ZSE_NO_PORT		1
#define ZSE_NO_ADDR		2
#define ZSE_HOST_NOTFOUND	3
#define ZSE_TIMEOUT		4


typedef void __fastcall (__closure *TErrorEvent)(System::TObject *Sender,
						int	error, AnsiString errorstr, SOCKET aSocket);

class TZSocket : public TComponent
{
private:
	HWND			Handle;

	TNotifyEvent 	FOnClose;
	TNotifyEvent 	FOnConnect;
	TNotifyEvent 	FOnConnectionRequest;
	TNotifyEvent 	FOnDataAvailable;
    TErrorEvent		FOnError;
	TNotifyEvent 	FOnSendComplete;
	TNotifyEvent	FOnTimeout;
	TNotifyEvent	FOnNameResolved;
	TNotifyEvent	FOnNameLookupFailed;
	TNotifyEvent	FOnOKToWrite;

	AnsiString		FVersion;
	AnsiString		FXVersion;
	AnsiString		FText;
    AnsiString		FLimitAddr;
	AnsiString		FRemoteAddr;
	AnsiString		FRemotePort;
	AnsiString		FLocalPort;		// for listen
	SOCKET   		FSocket;
	SOCKET   		FMSocket;		// for listen
	int				FTimeout;
	int				FState;
	long			FBufferSize;
	long			FBytesAvailable;
    int				FBacklog;

	char			hostent[MAXGETHOSTSTRUCT];
	SOCKADDR_IN 	sin;
	PSERVENT		Pse;
	PHOSTENT		Phe;
	PPROTOENT	    Ppe;
	WSAData			initdata;
	HANDLE			FAsyncRequest;

	void __fastcall TZSocket::SetTimeout();
	void __fastcall TZSocket::ResetTimeout();
	void __fastcall SocketError(SOCKET Socket, AnsiString sockfunc, int error);
	AnsiString __fastcall TZSocket::SocketErrorText(int error);
	AnsiString __fastcall	TZSocket::GetText();
	void __fastcall 	TZSocket::SetText(AnsiString Text);

protected:

	void __fastcall TZSocket::WndProc(TMessage& msg);
	virtual void __fastcall WSAsyncSelect(TMessage& msg);
	void __fastcall TZSocket::WMTimer(TMessage& msg);
	void __fastcall TZSocket::WMNameDNS(TMessage& msg);

public:

	virtual __fastcall	TZSocket(TComponent* Owner);
	virtual __fastcall 	TZSocket::~TZSocket();
	void __fastcall 	TZSocket::ZConnect();
	long __fastcall 	TZSocket::ZReceive(SOCKET Socket, unsigned char *Text, long length);
	long __fastcall 	TZSocket::ZPeek(SOCKET Socket, unsigned char *buffer, long length);
	long __fastcall 	TZSocket::ZReceiveUrgent(SOCKET Socket, unsigned char *buffer, long length);
	long __fastcall 	TZSocket::ZSend(SOCKET Socket, unsigned char *buffer, long length);
	long __fastcall 	TZSocket::ZSendUrgent(SOCKET Socket, unsigned char *buffer, long length);
	void __fastcall 	TZSocket::ZListen();
	void __fastcall 	TZSocket::ZCancelListen();
	void __fastcall		TZSocket::ZAsyncCancel();

	SOCKET __fastcall 	TZSocket::ZAccept();
	void __fastcall 	TZSocket::ZClose();
    AnsiString __fastcall 	TZSocket::GetRemoteAddr(SOCKET Socket);
	int __fastcall 			TZSocket::GetRemotePort(SOCKET Socket);
	AnsiString __fastcall 	TZSocket::GetLocalHostName();
	AnsiString __fastcall 	TZSocket::GetLocalAddr();
	AnsiString __fastcall 	TZSocket::GetPeerAddr();
	int __fastcall 			TZSocket::GetPeerPort();
  	void __fastcall 		TZSocket::GetRemoteName(AnsiString hostname);

    int __fastcall 			TZSocket::IOCtl(SOCKET Socket, long param, unsigned long *cmd);
    int	__fastcall			TZSocket::SetSocketOption(SOCKET Socket, int linger, int timeout);
    int	__fastcall			TZSocket::GetSocketOption(SOCKET Socket, int level, int optname,
					                           char *optval, int *optlen);
  __published:

	__property long 		BufferSize = {read=FBufferSize, write=FBufferSize, default=8192};
	__property AnsiString 	RemoteAddr = {read=FRemoteAddr, write=FRemoteAddr};
   	__property AnsiString 	Text = {read=GetText, write=SetText};
	__property AnsiString 	RemotePort = {read=FRemotePort, write=FRemotePort};
	__property AnsiString	LocalPort = {read=FLocalPort, write=FLocalPort};
	__property int 			Timeout = {read=FTimeout,write=FTimeout,default=30};
    __property AnsiString	Version = {read=FVersion, write=FXVersion};
    __property int			ListenBacklog = {read=FBacklog, write=FBacklog};

// read only

	__property AnsiString 	LimitAddr = {read=FLimitAddr, write=FLimitAddr};
	__property AnsiString	LocalAddr = {read=GetLocalAddr};
    __property AnsiString 	LocalHostName = {read=GetLocalHostName};
	__property AnsiString 	PeerPort = {read=GetPeerPort};
	__property AnsiString 	PeerAddr = {read=GetPeerAddr};
	__property long			BytesAvailable = {read=FBytesAvailable};
	__property SOCKET		SocketHandle = {read=FSocket, write=FSocket};
	__property SOCKET		ListenSocketHandle = {read=FMSocket, write=FMSocket};
	__property int			State = {read=FState};

// inherited

  	__property ComponentState;

//events

	__property TNotifyEvent OnNameLookupFailed =
				{read=FOnNameLookupFailed, write=FOnNameLookupFailed};

	__property TNotifyEvent OnNameResolved =
				{read=FOnNameResolved, write=FOnNameResolved};

	__property TNotifyEvent OnSendComplete =
				{read=FOnSendComplete, write=FOnSendComplete};

	__property TNotifyEvent OnOKToWrite =
				{read=FOnOKToWrite, write=FOnOKToWrite};

	__property TNotifyEvent OnClose =
				{read=FOnClose, write=FOnClose};

	__property TNotifyEvent OnConnectionRequest =
				{read=FOnConnectionRequest, write=FOnConnectionRequest};

	__property TNotifyEvent	OnConnect =
				{read=FOnConnect, write=FOnConnect};

	__property TErrorEvent OnError =
				{read=FOnError, write=FOnError};

	__property TNotifyEvent OnDataAvailable =
				{read=FOnDataAvailable, write=FOnDataAvailable};

	__property TNotifyEvent OnTimeout =
				{read=FOnTimeout, write=FOnTimeout};

};
#endif
